import React, { useState } from 'react';
import { Link } from 'gatsby';
import { IoIosSearch, IoIosClose } from 'react-icons/io';
import { DrawerProvider } from '../drawer/drawer-context';
import Button from '../../components/button/button';
import Menu from './menu';
import MobileMenu from './mobile-menu';
import SearchContainer from '../../containers/search/search';
import HeaderWrapper, {
  NavbarWrapper,
  NavbarWrapper2,
  Logo,
  MenuWrapper,
  NavSearchButton,
  NavSearchWrapper,
  SearchCloseButton,
  NavSearchFromWrapper,
} from './navbar.style';
import LogoImage from '../../images/logo.png';

type NavbarProps = {
  className?: string;
};

const MenuItems = [
  {
    label: 'Home',
    url: '/',
  },
  {
    label: 'About',
    url: 'https://disaster.salvationarmyusa.org/aboutus/',
  },
  {
    label: 'Volunteer',
    url: 'https://disaster.salvationarmyusa.org/volunteer/new/',
  },
  {
    label: 'Give',
    url: 'https://disaster.salvationarmyusa.org/give/',
  },
  {
    label: 'Train',
    url: 'https://disaster.salvationarmyusa.org/training/',
  },

  {
    label: 'Gallery',
    url: 'https://www.ministrytoolkit.org/portals/nkimdayg/EDSPortal',
  },
  {
    label: 'EDS Portal',
    url: 'https://disaster.salvationarmyusa.org/volunteer/',
  },
];

const Navbar: React.FunctionComponent<NavbarProps> = ({
  className,
  ...props
}) => {
  const [state, setState] = useState({
    toggle: false,
    search: '',
  });

  const toggleHandle = () => {
    setState({
      ...state,
      toggle: !state.toggle,
    });
  };

  // Add all classs to an array
  const addAllClasses = ['header'];

  // className prop checking
  if (className) {
    addAllClasses.push(className);
  }

  return (
    <HeaderWrapper className={addAllClasses.join(' ')} {...props}>
      <NavbarWrapper className="navbar">
        <DrawerProvider>
          <MobileMenu items={MenuItems} logo={LogoImage} />
        </DrawerProvider>
        <Logo>
          <Link to="/">
            <img src={LogoImage} alt="logo" />
          </Link>
        </Logo>
    
        <Link to="https://give.helpsalvationarmy.org/">
          <Button title="Donate" type="submit" />
        </Link>
      
      </NavbarWrapper>
      <NavbarWrapper2 className="navbar">
     
     
        <MenuWrapper>
          <Menu items={MenuItems} />
        </MenuWrapper>
        <NavSearchButton
          type="button"
          aria-label="search"
          onClick={toggleHandle}
        >
          <IoIosSearch size="23px" />
        </NavSearchButton>
       
      </NavbarWrapper2>
      

      <NavSearchWrapper className={state.toggle === true ? 'expand' : ''}>
        <NavSearchFromWrapper>
          <SearchContainer />
          <SearchCloseButton
            type="submit"
            aria-label="close"
            onClick={toggleHandle}
          >
            <IoIosClose />
          </SearchCloseButton>
        </NavSearchFromWrapper>
      </NavSearchWrapper>
    </HeaderWrapper>
  );
};

export default Navbar;
